﻿//////////////////////////////////////////////
// ImageManager.h
//
//////////////////////////////////////////////

/// Defines / Macros -------------------------

#pragma once

/// Forward decl -----------------------------

namespace nkWinUi
{
	class System ;
}

/// Includes ---------------------------------

// nkWinUi
#include "../Dll/DllDefines.h"

#include "Image.h"
	
// nkCommon
#include <nilkinsCommon/Patterns/MaybeSingletonClass.h>

// nkMemory
#include <NilkinsMemory/Containers/StringView.h>

#include <NilkinsMemory/Pointers/UniquePtr.h>

// Standards
#include <string>
#include <unordered_map>

/// Class ------------------------------------

namespace nkWinUi
{
	class DLL_WINUI_EXPORT ImageManager final : public nkCommon::MaybeSingletonClass<ImageManager>
	{
		public :

			// Getters
			System* getSystem () const ;
		
			// Memory management
			Image* createOrRetrieve (nkMemory::StringView name) ;
			Image* record (nkMemory::StringView name, nkMemory::UniquePtr<Image> resource) ;
			Image* get (nkMemory::StringView name) const ;
			Image* getByIndex (unsigned int index) const ;
			void rename (nkMemory::StringView oldName, nkMemory::StringView newName) ;
			void erase (nkMemory::StringView name) ;
			nkMemory::UniquePtr<Image> relinquish (nkMemory::StringView name) ;

		private :

			// Functions
			// Constructor, destructor
			ImageManager (bool isSingleton) noexcept ;
			ImageManager (System* system) noexcept ;
			ImageManager (const ImageManager&) = delete ;

			// Operators
			ImageManager& operator= (const ImageManager&) = delete ;

		private :

			// Attributes
			// Memory
			std::unordered_map<std::string, nkMemory::UniquePtr<Image>> _memory ;
			System* _system ;

		private :

			friend class nkCommon::MaybeSingletonClass<ImageManager> ;
			friend class System ;
	} ;
}